

<?php $__env->startPush('style'); ?>
<style>
    .info-box {
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .card {
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .table-responsive {
        border-radius: 8px;
    }
    .filter-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 15px;
        padding: 20px;
        margin-bottom: 20px;
    }
    .stat-card {
        transition: transform 0.2s;
    }
    .stat-card:hover {
        transform: translateY(-2px);
    }
    .btn-group .btn {
        margin-right: 2px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('head'); ?>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.7.1/css/buttons.bootstrap4.min.css">
<!-- Date Range Picker CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
<!-- Additional DataTables Extensions -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.bootstrap4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('main'); ?>
<!-- Content Header -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1><i class="fas fa-shopping-bag"></i> Direct Sales Report</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Reports</a></li>
                    <li class="breadcrumb-item active">Direct Sales Report</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        
        <!-- Summary Cards Row -->
        <div class="row">
            <!-- Total Sales -->
            <div class="col-lg-3 col-6">
                <div class="info-box stat-card">
                    <span class="info-box-icon bg-info elevation-1"><i class="fas fa-shopping-cart"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Direct Sales</span>
                        <span class="info-box-number"><?php echo e($sales->count()); ?></span>
                    </div>
                </div>
            </div>
            
            <!-- Total Quantity -->
            <div class="col-lg-3 col-6">
                <div class="info-box stat-card">
                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-boxes"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Quantity Sold</span>
                        <span class="info-box-number"><?php echo e(number_format($totalSale)); ?></span>
                    </div>
                </div>
            </div>
            
            <!-- Total Amount -->
            <div class="col-lg-3 col-6">
                <div class="info-box stat-card">
                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-money-bill-wave"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Revenue</span>
                        <span class="info-box-number">BHD <?php echo e(number_format($totalAmount, 2)); ?></span>
                    </div>
                </div>
            </div>
            
            <!-- Total Profit -->
            <div class="col-lg-3 col-6">
                <div class="info-box stat-card">
                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-chart-line"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Profit</span>
                        <span class="info-box-number">BHD <?php echo e(number_format($totalProfit, 2)); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="row">
            <div class="col-12">
                <div class="card card-outline card-primary">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-filter mr-2"></i>Advanced Filters
                        </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <label for="date_range">Date Range:</label>
                                <input type="text" name="date_range" id="date_range" class="form-control"
                                    placeholder="Select Date Range">
                            </div>
                            <div class="col-md-4">
                                <label for="product_filter">Product Type:</label>
                                <select id="product_filter" class="form-control">
                                    <option value="">All Product Types</option>
                                    <?php $__currentLoopData = $sales->unique('product_type'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sale->product_type); ?>"><?php echo e($sale->product_type); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="customer_filter">Customer:</label>
                                <select id="customer_filter" class="form-control">
                                    <option value="">All Customers</option>
                                    <?php $__currentLoopData = $sales->where('customer')->unique('customer.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($sale->customer): ?>
                                            <option value="<?php echo e($sale->customer->name); ?>"><?php echo e($sale->customer->name); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <button type="button" id="apply_filters" class="btn btn-primary">
                                    <i class="fas fa-search"></i> Apply Filters
                                </button>
                                <button type="button" id="clear_filters" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> Clear Filters
                                </button>
                                <button type="button" id="export_data" class="btn btn-success">
                                    <i class="fas fa-download"></i> Export to Excel
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Data Table Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-table mr-1"></i>
                            Direct Sales Data
                        </h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="maximize">
                                <i class="fas fa-expand"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="directSalesTable" class="table table-bordered table-striped table-hover">
                                <thead class="thead-dark">
                                    <tr>
                                        <th><i class="fas fa-hashtag"></i> ID</th>
                                        <th><i class="fas fa-box"></i> Product Type</th>
                                        <th><i class="fas fa-sticky-note"></i> Purchase Note</th>
                                        <th><i class="fas fa-money-bill"></i> Sell Price</th>
                                        <th><i class="fas fa-dollar-sign"></i> Cost Price</th>
                                        <th><i class="fas fa-chart-line"></i> Profit</th>
                                        <th><i class="fas fa-sort-numeric-up"></i> Quantity</th>
                                        <th><i class="fas fa-user"></i> Customer</th>
                                        <th><i class="fas fa-calendar"></i> Date & Time</th>
                                        <th><i class="fas fa-cogs"></i> Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><span class="badge badge-primary"><?php echo e($sale->id); ?></span></td>
                                            <td><?php echo e($sale->product_type); ?></td>
                                            <td><?php echo e($sale->purchase_note ?? '-'); ?></td>
                                            <td><strong>BHD <?php echo e(number_format($sale->direct_sell_price, 2)); ?></strong></td>
                                            <td>BHD <?php echo e(number_format($sale->direct_cost_price, 2)); ?></td>
                                            <td>
                                                <span class="badge badge-success">
                                                    BHD <?php echo e(number_format($sale->direct_profit, 2)); ?>

                                                </span>
                                            </td>
                                            <td><span class="badge badge-info"><?php echo e($sale->direct_sold_quantity); ?></span></td>
                                            <td><?php echo e($sale->customer ? $sale->customer->name : '<span class="text-muted">-</span>'); ?></td>
                                            <td>
                                                <small class="text-muted">
                                                    <?php echo e(\Carbon\Carbon::parse($sale->direct_date_time)->format('d M Y')); ?><br>
                                                    <?php echo e(\Carbon\Carbon::parse($sale->direct_date_time)->format('h:i A')); ?>

                                                </small>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="<?php echo e(route('direct-sales.edit', $sale->id)); ?>" 
                                                       class="btn btn-sm btn-warning" title="Edit">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('sales.table.invoice.public', 'DS-' . $sale->id)); ?>" 
                                                       target="_blank" class="btn btn-sm btn-info" title="Print Invoice">
                                                        <i class="fas fa-print"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('direct-sales.destroy', $sale->id)); ?>" 
                                                          method="POST" style="display: inline;"
                                                          onsubmit="return confirm('Are you sure you want to delete this sale?')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr class="table-info">
                                        <th colspan="3"><strong>Totals:</strong></th>
                                        <th><strong>BHD <?php echo e(number_format($sales->sum('direct_sell_price'), 2)); ?></strong></th>
                                        <th><strong>BHD <?php echo e(number_format($sales->sum('direct_cost_price'), 2)); ?></strong></th>
                                        <th><strong>BHD <?php echo e(number_format($totalProfit, 2)); ?></strong></th>
                                        <th><strong><?php echo e(number_format($totalSale)); ?></strong></th>
                                        <th colspan="3"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        
                        <!-- Pagination -->
                        <div class="card-footer clearfix">
                            <?php echo e($sales->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Initialize DataTable with advanced features
    $('#directSalesTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "order": [[ 0, "desc" ]],
        "pageLength": 25,
        "lengthMenu": [10, 25, 50, 100],
        "language": {
            "search": "Search Sales:",
            "lengthMenu": "Show _MENU_ sales per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ sales",
            "paginate": {
                "first": "First",
                "last": "Last",
                "next": "Next",
                "previous": "Previous"
            }
        },
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'excel',
                text: 'Export to Excel',
                className: 'btn btn-success btn-sm'
            },
            {
                extend: 'pdf',
                text: 'Export to PDF',
                className: 'btn btn-danger btn-sm'
            },
            {
                extend: 'print',
                text: 'Print Report',
                className: 'btn btn-info btn-sm'
            }
        ]
    });

    // Filter functionality
    $('#filterBtn').click(function() {
        var dateRange = $('#dateRange').val();
        var productType = $('#productType').val();
        var customer = $('#customer').val();
        
        // Create filter parameters
        var params = {};
        if (dateRange) params.date_range = dateRange;
        if (productType) params.product_type = productType;
        if (customer) params.customer = customer;
        
        // Reload page with filters
        var url = window.location.pathname;
        if (Object.keys(params).length > 0) {
            url += '?' + $.param(params);
        }
        window.location.href = url;
    });

    // Clear filters
    $('#clearFilters').click(function() {
        $('#dateRange').val('');
        $('#productType').val('');
        $('#customer').val('');
        window.location.href = window.location.pathname;
    });

    // Toastr configuration
    <?php if(session('success')): ?>
        toastr.success('<?php echo e(session('success')); ?>');
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        toastr.error('<?php echo e(session('error')); ?>');
    <?php endif; ?>

    // Auto-refresh functionality (optional)
    setTimeout(function() {
        $('.info-box-number').each(function() {
            $(this).addClass('animated pulse');
        });
    }, 1000);
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/pos24.3/resources/views/direct_sell/report.blade.php ENDPATH**/ ?>